#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
//#include <conio.h> 'getch' not used and just for windows dos console
//#include <string.h> 'strncpy' not used

#define elseif else if
#define null 0

#define true 1
#define false 0
typedef int bool;

//#define case_operator case'+':case'-':case'*':case'/':case'%':case'!':case'^':case')':
#define case_whitespace case'\n':case'\r':case'\t':case' ':
#define case_number case'0':case'1':case'2':case'3':case'4':case'5':case'6':case'7':case'8':case'9':

//prototypes
double doubleFactorial(double x);
char *calcexp(char *c, double *result);
char *calcpoint(char *c, double *result);
char *calc(char *c, double *result);
char *readexp10(char *c, double *num);
char *readfloat(char *c, double *num, int sign);
char *readnumber(char *c, double *num);
char *readwholefile(FILE *f);

double doubleFactorial(double x){
	#define lnPi_2_4 0.11289567632236371618154880747372
	if(fmod(x,1) == 0){ //if integer
		double num = 1;
		if(fmod(x,2) != 0){
			if(x > 1){
				double i;
				for(i = 3;i <= x;i += 2){
					num *= i;
				}
			}else{
				double xp2 = x + 2;
				double i;
				for(i = -1;i >= xp2;i -= 2){
					num /= i;
				}
			}
		}else{
			if(x >= 0){
				double i;
				for(i = 2;i <= x;i += 2){
					num *= i;
				}
			}else
				return INFINITY;
		}
		return num;
	}
	return exp(M_LN2 * x / 2 + lnPi_2_4 * (cos(M_PI * x) - 1)) * tgamma(1 + x / 2);
}

char *calcexp(char *c, double *result){
	double x;

	if(c = readnumber(c,result)) do
		switch(*c){
		case '^':
			if(!(c = calcexp(c + 1,&x)))
				return null;
			*result = pow(*result,x);
			break;
		case '!':
			if(c[1] == '!'){
				*result = doubleFactorial(*result);
				c += 2;
				break;
			}
			*result = tgamma(*result + 1);
			c++;
			break;
		case_whitespace
			c++;
			break; //same as continue, but continue does't work cause of do while loop
		default:
			return c;
		}
	while(1);
	return null;
}

char *calcpoint(char *c, double *result){
	double x;

	if(c = calcexp(c,result)) do
		switch(*c){
		case '*':
			if(!(c = calcexp(c + 1,&x)))
				return null;
			*result *= x;
			break;
		case '/':
			if(!(c = calcexp(c + 1,&x)))
				return null;
			*result /= x;
			break;
		case '%':
			if(!(c = calcexp(c + 1,&x)))
				return null;
			*result = fmod(*result,x);
			break;
		default:
			return c;
		}
	while(1);
	return null;
}

char *calc(char *c, double *result){
	double x;

	if(c = calcpoint(c,result)) do
		switch(*c){
		case '+':
			// printf("%d\n",*result);
			if(!(c = calcpoint(c + 1,&x)))
				return null;
			*result += x;
			break;
		case '-':
			if(!(c = calcpoint(c + 1,&x)))
				return null;
			*result -= x;
			break;
		default:
			return c;
		}
	while(1);
	return null;
}

char *readexp10(char *c, double *num){
	int x;
	int sign = 1;
	int i;
	double y = 1;

	for(;;)
		switch(*c){
		case_number
			x = *c - '0';
			for(;;){
				c++;
				switch(*c){
				case_number
					x = x * 10 + *c - '0';
					continue;
				default:
					for(i = 0;i < x;i++){
						y *= 10;
					}
					if(sign == 1){
						*num *= y;
					}else{
						*num /= y;
					}
					return c;
				}
			}
		case '-':
			sign *= -1;
		case '+':
			c++;
			continue;
		default:
			return null;
		}
}

char *readfloat(char *c, double *num, int sign){
	double x = 10;
	double y = 0;

	for(;;){
		switch(*c){
		case_number
			y += (*c - '0') / x;
			x *= 10;
			c++;
			continue;
		default:
			*num += sign * y;
		}

		switch(*c){
		case 'e':
		case 'E':
			return readexp10(c + 1,num);
		default:
			return c;
		}
	}
}

char *readnumber(char *c, double *num){
	int sign = 1;

	for(;;)
		switch(*c){
		case_number
			*num = *c - '0';
			for(;;){
				c++;
				switch(*c){
				case_number
					*num = *num * 10 + *c - '0';
					continue;
				default:
					*num *= sign;
				}
				switch(*c){
				case 'e':
				case 'E':
					return readexp10(c + 1,num);
				case '.':
					return readfloat(c + 1,num,sign);
				default:
					return c;
				}
			}
		case '.':
			*num = 0;
			return readfloat(c + 1,num,sign);
		case '-':
			sign *= -1;
		case '+': //+ is always the same value
		case_whitespace
			c++;
			continue;
		case '(':
			if(!(c = calc(c + 1,num)) || *c != ')')
				return null;

			*num *= sign;
			return c + 1;
		default:
			return null;
		}
}

char *readwholefile(FILE *f){
	fseek(f,0,2);
	int size = ftell(f);
	fseek(f,0,0);
	//malloc instead of realloc, c gets a new address
	char *c = malloc(size + 1);
	int sizex = fread(c,1,size,f);
	c[sizex] = '\0'; //there is still space for '\0'
	return c;
}

int main(int argc, char *argv[]){
	char form[256];
	char *c, *end;
	double x;
	FILE *f;

	int i;
	for(i = 1;i < argc;i++){
		//"-i" stands for input
		if(strcmp(argv[i],"-i") == 0){
			c = readwholefile(stdin);
			if((end = calc(c,&x)) && *end == 0)
				printf("%.12g",x);
			else
				printf("Invalid calculation!");
			free(c);
			return 0;
		}
	}

	puts("Simple scientific calculator\n"
			 "'ctrl+c' for exit\n"
			 "'f:*' for using a file\n");

	//readnumber(c,&n);

	//printf("%d\n",n);

	for(;;){
		printf("calc: ");
		fgets(form,256,stdin);
		int n = strlen(form) - 1;
		if(form[n] == '\n')
			form[n] = '\0';
		switch(*form){
		case 0:
			puts("You have nothing typed in.");
			continue;
		case 'f':
			if(form[1] == ':'){
				if(f = fopen(form + 2,"rb")){
					c = readwholefile(f);
					fclose(f);
					if((end = calc(c,&x)) && *end == 0)
						printf("%.12g\n",x);
					else
						puts("Invalid calculation!");
					free(c); //output first
					//puts(form);
				}else
					puts("Failed to open this file.");
				continue;
			}
		}
		if((end = calc(form,&x)) && *end == 0)
			printf("%.12g\n",x);
		else
			puts("Invalid calculation!");
		//getch();
		//puts("");
	}
}
